/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Person;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPersonRequest;
import java.util.List;

public class PersonRequest
extends BaseRequest
implements IPersonRequest {
    public PersonRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Person.class);
    }

    @Override
    public void get(ICallback<? super Person> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Person get() throws ClientException {
        return (Person)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Person> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Person sourcePerson, ICallback<? super Person> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePerson);
    }

    @Override
    public Person patch(Person sourcePerson) throws ClientException {
        return (Person)this.send(HttpMethod.PATCH, sourcePerson);
    }

    @Override
    public void post(Person newPerson, ICallback<? super Person> callback) {
        this.send(HttpMethod.POST, callback, newPerson);
    }

    @Override
    public Person post(Person newPerson) throws ClientException {
        return (Person)this.send(HttpMethod.POST, newPerson);
    }

    @Override
    public void put(Person newPerson, ICallback<? super Person> callback) {
        this.send(HttpMethod.PUT, callback, newPerson);
    }

    @Override
    public Person put(Person newPerson) throws ClientException {
        return (Person)this.send(HttpMethod.PUT, newPerson);
    }

    @Override
    public IPersonRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPersonRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

