/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.DateTimeTimeZone;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.CalendarGetScheduleCollectionRequest;
import com.microsoft.graph.requests.extensions.ICalendarGetScheduleCollectionRequest;
import com.microsoft.graph.requests.extensions.ICalendarGetScheduleCollectionRequestBuilder;
import java.util.List;

public class CalendarGetScheduleCollectionRequestBuilder
extends BaseActionRequestBuilder
implements ICalendarGetScheduleCollectionRequestBuilder {
    public CalendarGetScheduleCollectionRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, List<String> schedules, DateTimeTimeZone endTime, DateTimeTimeZone startTime, Integer availabilityViewInterval) {
        super(requestUrl, client, requestOptions);
        if (schedules != null) {
            this.bodyParams.put("schedules", schedules);
        }
        if (endTime != null) {
            this.bodyParams.put("endTime", endTime);
        }
        if (startTime != null) {
            this.bodyParams.put("startTime", startTime);
        }
        if (availabilityViewInterval != null) {
            this.bodyParams.put("availabilityViewInterval", availabilityViewInterval);
        }
    }

    @Override
    public ICalendarGetScheduleCollectionRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public ICalendarGetScheduleCollectionRequest buildRequest(List<? extends Option> requestOptions) {
        CalendarGetScheduleCollectionRequest request = new CalendarGetScheduleCollectionRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("schedules")) {
            request.body.schedules = (List)this.getParameter("schedules");
        }
        if (this.hasParameter("endTime")) {
            request.body.endTime = (DateTimeTimeZone)this.getParameter("endTime");
        }
        if (this.hasParameter("startTime")) {
            request.body.startTime = (DateTimeTimeZone)this.getParameter("startTime");
        }
        if (this.hasParameter("availabilityViewInterval")) {
            request.body.availabilityViewInterval = (Integer)this.getParameter("availabilityViewInterval");
        }
        return request;
    }
}

