/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.Response;

public class HttpResponseHeadersHelper {
    public Map<String, String> getResponseHeadersAsMapStringString(Response response) {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Headers responseHeaders = response.headers();
        for (int index = 0; index < responseHeaders.size(); ++index) {
            String headerName = responseHeaders.name(index);
            String headerValue = responseHeaders.value(index);
            if (headerName == null || headerValue == null) break;
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public Map<String, List<String>> getResponseHeadersAsMapOfStringList(Response response) {
        Map headerFields = response.headers().toMultimap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("%d", response.code()));
        headerFields.put("responseCode", list);
        return headerFields;
    }
}

