/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SiteRemoveBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteRemoveCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteRemoveCollectionRequest;
import com.microsoft.graph.requests.extensions.SiteRemoveCollectionPage;
import com.microsoft.graph.requests.extensions.SiteRemoveCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SiteRemoveCollectionResponse;
import java.util.List;

public class SiteRemoveCollectionRequest
extends BaseCollectionRequest<SiteRemoveCollectionResponse, ISiteRemoveCollectionPage>
implements ISiteRemoveCollectionRequest {
    protected final SiteRemoveBody body = new SiteRemoveBody();

    public SiteRemoveCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteRemoveCollectionResponse.class, ISiteRemoveCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super ISiteRemoveCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SiteRemoveCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteRemoveCollectionPage post() throws ClientException {
        SiteRemoveCollectionResponse response = (SiteRemoveCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public ISiteRemoveCollectionPage buildFromResponse(SiteRemoveCollectionResponse response) {
        SiteRemoveCollectionRequestBuilder builder = response.nextLink != null ? new SiteRemoveCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        SiteRemoveCollectionPage page = new SiteRemoveCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ISiteRemoveCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteRemoveCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISiteRemoveCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ISiteRemoveCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ISiteRemoveCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

