/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookRangeView;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookRangeViewCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookRangeViewCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookRangeViewCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookRangeViewCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookRangeViewCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookRangeViewRequestBuilder;
import java.util.List;

public class WorkbookRangeViewCollectionRequest
extends BaseCollectionRequest<WorkbookRangeViewCollectionResponse, IWorkbookRangeViewCollectionPage>
implements IWorkbookRangeViewCollectionRequest {
    public WorkbookRangeViewCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeViewCollectionResponse.class, IWorkbookRangeViewCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookRangeViewCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookRangeViewCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookRangeViewCollectionPage get() throws ClientException {
        WorkbookRangeViewCollectionResponse response = (WorkbookRangeViewCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookRangeView newWorkbookRangeView, ICallback<WorkbookRangeView> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookRangeViewRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookRangeView, callback);
    }

    @Override
    public WorkbookRangeView post(WorkbookRangeView newWorkbookRangeView) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookRangeViewRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookRangeView);
    }

    @Override
    public IWorkbookRangeViewCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookRangeViewCollectionPage buildFromResponse(WorkbookRangeViewCollectionResponse response) {
        WorkbookRangeViewCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookRangeViewCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookRangeViewCollectionPage page = new WorkbookRangeViewCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

