/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IUserDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.UserDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.UserDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserDeltaCollectionResponse;
import java.util.List;

public class UserDeltaCollectionRequest
extends BaseCollectionRequest<UserDeltaCollectionResponse, IUserDeltaCollectionPage>
implements IUserDeltaCollectionRequest {
    public UserDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserDeltaCollectionResponse.class, IUserDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserDeltaCollectionPage get() throws ClientException {
        UserDeltaCollectionResponse response = (UserDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IUserDeltaCollectionPage buildFromResponse(UserDeltaCollectionResponse response) {
        UserDeltaCollectionRequestBuilder builder = response.nextLink != null ? new UserDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserDeltaCollectionPage page = new UserDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IUserDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IUserDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }
}

