/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.SectionGroup;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISectionGroupRequest;
import java.util.List;

public class SectionGroupRequest
extends BaseRequest
implements ISectionGroupRequest {
    public SectionGroupRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SectionGroup.class);
    }

    @Override
    public void get(ICallback<SectionGroup> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public SectionGroup get() throws ClientException {
        return (SectionGroup)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<SectionGroup> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(SectionGroup sourceSectionGroup, ICallback<SectionGroup> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSectionGroup);
    }

    @Override
    public SectionGroup patch(SectionGroup sourceSectionGroup) throws ClientException {
        return (SectionGroup)this.send(HttpMethod.PATCH, sourceSectionGroup);
    }

    @Override
    public void post(SectionGroup newSectionGroup, ICallback<SectionGroup> callback) {
        this.send(HttpMethod.POST, callback, newSectionGroup);
    }

    @Override
    public SectionGroup post(SectionGroup newSectionGroup) throws ClientException {
        return (SectionGroup)this.send(HttpMethod.POST, newSectionGroup);
    }

    @Override
    public void put(SectionGroup newSectionGroup, ICallback<SectionGroup> callback) {
        this.send(HttpMethod.PUT, callback, newSectionGroup);
    }

    @Override
    public SectionGroup put(SectionGroup newSectionGroup) throws ClientException {
        return (SectionGroup)this.send(HttpMethod.PUT, newSectionGroup);
    }

    @Override
    public ISectionGroupRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISectionGroupRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public ISectionGroupRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

