/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.SchemaExtension;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISchemaExtensionRequest;
import java.util.List;

public class SchemaExtensionRequest
extends BaseRequest
implements ISchemaExtensionRequest {
    public SchemaExtensionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SchemaExtension.class);
    }

    @Override
    public void get(ICallback<SchemaExtension> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public SchemaExtension get() throws ClientException {
        return (SchemaExtension)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<SchemaExtension> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(SchemaExtension sourceSchemaExtension, ICallback<SchemaExtension> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSchemaExtension);
    }

    @Override
    public SchemaExtension patch(SchemaExtension sourceSchemaExtension) throws ClientException {
        return (SchemaExtension)this.send(HttpMethod.PATCH, sourceSchemaExtension);
    }

    @Override
    public void post(SchemaExtension newSchemaExtension, ICallback<SchemaExtension> callback) {
        this.send(HttpMethod.POST, callback, newSchemaExtension);
    }

    @Override
    public SchemaExtension post(SchemaExtension newSchemaExtension) throws ClientException {
        return (SchemaExtension)this.send(HttpMethod.POST, newSchemaExtension);
    }

    @Override
    public void put(SchemaExtension newSchemaExtension, ICallback<SchemaExtension> callback) {
        this.send(HttpMethod.PUT, callback, newSchemaExtension);
    }

    @Override
    public SchemaExtension put(SchemaExtension newSchemaExtension) throws ClientException {
        return (SchemaExtension)this.send(HttpMethod.PUT, newSchemaExtension);
    }

    @Override
    public ISchemaExtensionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISchemaExtensionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public ISchemaExtensionRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

