/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Room;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoomCollectionPage;
import com.microsoft.graph.requests.extensions.IRoomCollectionRequest;
import com.microsoft.graph.requests.extensions.RoomCollectionPage;
import com.microsoft.graph.requests.extensions.RoomCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.RoomCollectionResponse;
import com.microsoft.graph.requests.extensions.RoomRequestBuilder;
import java.util.List;

public class RoomCollectionRequest
extends BaseCollectionRequest<RoomCollectionResponse, IRoomCollectionPage>
implements IRoomCollectionRequest {
    public RoomCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoomCollectionResponse.class, IRoomCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRoomCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RoomCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRoomCollectionPage get() throws ClientException {
        RoomCollectionResponse response = (RoomCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Room newRoom, ICallback<Room> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RoomRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRoom, callback);
    }

    @Override
    public Room post(Room newRoom) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoomRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRoom);
    }

    @Override
    public IRoomCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRoomCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IRoomCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRoomCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IRoomCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IRoomCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IRoomCollectionPage buildFromResponse(RoomCollectionResponse response) {
        RoomCollectionRequestBuilder builder = response.nextLink != null ? new RoomCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RoomCollectionPage page = new RoomCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

