/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PermissionGrantPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPermissionGrantPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IPermissionGrantPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.PermissionGrantPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.PermissionGrantPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionGrantPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.PermissionGrantPolicyRequestBuilder;
import java.util.List;

public class PermissionGrantPolicyCollectionRequest
extends BaseCollectionRequest<PermissionGrantPolicyCollectionResponse, IPermissionGrantPolicyCollectionPage>
implements IPermissionGrantPolicyCollectionRequest {
    public PermissionGrantPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PermissionGrantPolicyCollectionResponse.class, IPermissionGrantPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPermissionGrantPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PermissionGrantPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPermissionGrantPolicyCollectionPage get() throws ClientException {
        PermissionGrantPolicyCollectionResponse response = (PermissionGrantPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PermissionGrantPolicy newPermissionGrantPolicy, ICallback<PermissionGrantPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PermissionGrantPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPermissionGrantPolicy, callback);
    }

    @Override
    public PermissionGrantPolicy post(PermissionGrantPolicy newPermissionGrantPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PermissionGrantPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPermissionGrantPolicy);
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPermissionGrantPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPermissionGrantPolicyCollectionPage buildFromResponse(PermissionGrantPolicyCollectionResponse response) {
        PermissionGrantPolicyCollectionRequestBuilder builder = response.nextLink != null ? new PermissionGrantPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PermissionGrantPolicyCollectionPage page = new PermissionGrantPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

