/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PermissionGrantConditionSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPermissionGrantConditionSetCollectionPage;
import com.microsoft.graph.requests.extensions.IPermissionGrantConditionSetCollectionRequest;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetCollectionPage;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetCollectionResponse;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetRequestBuilder;
import java.util.List;

public class PermissionGrantConditionSetCollectionRequest
extends BaseCollectionRequest<PermissionGrantConditionSetCollectionResponse, IPermissionGrantConditionSetCollectionPage>
implements IPermissionGrantConditionSetCollectionRequest {
    public PermissionGrantConditionSetCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PermissionGrantConditionSetCollectionResponse.class, IPermissionGrantConditionSetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPermissionGrantConditionSetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PermissionGrantConditionSetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPermissionGrantConditionSetCollectionPage get() throws ClientException {
        PermissionGrantConditionSetCollectionResponse response = (PermissionGrantConditionSetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PermissionGrantConditionSet newPermissionGrantConditionSet, ICallback<PermissionGrantConditionSet> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PermissionGrantConditionSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPermissionGrantConditionSet, callback);
    }

    @Override
    public PermissionGrantConditionSet post(PermissionGrantConditionSet newPermissionGrantConditionSet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PermissionGrantConditionSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPermissionGrantConditionSet);
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPermissionGrantConditionSetCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPermissionGrantConditionSetCollectionPage buildFromResponse(PermissionGrantConditionSetCollectionResponse response) {
        PermissionGrantConditionSetCollectionRequestBuilder builder = response.nextLink != null ? new PermissionGrantConditionSetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PermissionGrantConditionSetCollectionPage page = new PermissionGrantConditionSetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

