/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.NamedLocation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INamedLocationCollectionPage;
import com.microsoft.graph.requests.extensions.INamedLocationCollectionRequest;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionPage;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionResponse;
import com.microsoft.graph.requests.extensions.NamedLocationRequestBuilder;
import java.util.List;

public class NamedLocationCollectionRequest
extends BaseCollectionRequest<NamedLocationCollectionResponse, INamedLocationCollectionPage>
implements INamedLocationCollectionRequest {
    public NamedLocationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NamedLocationCollectionResponse.class, INamedLocationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<INamedLocationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(NamedLocationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public INamedLocationCollectionPage get() throws ClientException {
        NamedLocationCollectionResponse response = (NamedLocationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(NamedLocation newNamedLocation, ICallback<NamedLocation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new NamedLocationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNamedLocation, callback);
    }

    @Override
    public NamedLocation post(NamedLocation newNamedLocation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NamedLocationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNamedLocation);
    }

    @Override
    public INamedLocationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public INamedLocationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public INamedLocationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public INamedLocationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public INamedLocationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public INamedLocationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public INamedLocationCollectionPage buildFromResponse(NamedLocationCollectionResponse response) {
        NamedLocationCollectionRequestBuilder builder = response.nextLink != null ? new NamedLocationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        NamedLocationCollectionPage page = new NamedLocationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

