/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppContentFile;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppContentFileCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppContentFileCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentFileCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileAppContentFileRequestBuilder;
import java.util.List;

public class MobileAppContentFileCollectionRequest
extends BaseCollectionRequest<MobileAppContentFileCollectionResponse, IMobileAppContentFileCollectionPage>
implements IMobileAppContentFileCollectionRequest {
    public MobileAppContentFileCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppContentFileCollectionResponse.class, IMobileAppContentFileCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppContentFileCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppContentFileCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppContentFileCollectionPage get() throws ClientException {
        MobileAppContentFileCollectionResponse response = (MobileAppContentFileCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppContentFile newMobileAppContentFile, ICallback<MobileAppContentFile> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppContentFile, callback);
    }

    @Override
    public MobileAppContentFile post(MobileAppContentFile newMobileAppContentFile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppContentFile);
    }

    @Override
    public IMobileAppContentFileCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMobileAppContentFileCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMobileAppContentFileCollectionPage buildFromResponse(MobileAppContentFileCollectionResponse response) {
        MobileAppContentFileCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppContentFileCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppContentFileCollectionPage page = new MobileAppContentFileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

