/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.MobileAppCategory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class MobileAppCategoryWithReferenceRequest
extends BaseRequest
implements IMobileAppCategoryWithReferenceRequest {
    public MobileAppCategoryWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategory.class);
    }

    @Override
    public void post(MobileAppCategory newMobileAppCategory, IJsonBackedObject payload, ICallback<MobileAppCategory> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public MobileAppCategory post(MobileAppCategory newMobileAppCategory, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newMobileAppCategory;
        }
        return null;
    }

    @Override
    public void get(ICallback<MobileAppCategory> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public MobileAppCategory get() throws ClientException {
        return (MobileAppCategory)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<MobileAppCategory> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(MobileAppCategory sourceMobileAppCategory, ICallback<MobileAppCategory> callback) {
        this.send(HttpMethod.PATCH, callback, sourceMobileAppCategory);
    }

    @Override
    public MobileAppCategory patch(MobileAppCategory sourceMobileAppCategory) throws ClientException {
        return (MobileAppCategory)this.send(HttpMethod.PATCH, sourceMobileAppCategory);
    }

    @Override
    public IMobileAppCategoryWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppCategoryWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IMobileAppCategoryWithReferenceRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

