/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IMobileAppCategoryCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionWithReferencesRequestBuilder;
import java.util.List;

public class MobileAppCategoryCollectionWithReferencesRequest
extends BaseCollectionRequest<MobileAppCategoryCollectionResponse, IMobileAppCategoryCollectionPage>
implements IMobileAppCategoryCollectionWithReferencesRequest {
    public MobileAppCategoryCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategoryCollectionResponse.class, IMobileAppCategoryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppCategoryCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppCategoryCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesPage get() throws ClientException {
        MobileAppCategoryCollectionResponse response = (MobileAppCategoryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IMobileAppCategoryCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppCategoryCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IMobileAppCategoryCollectionWithReferencesPage buildFromResponse(MobileAppCategoryCollectionResponse response) {
        MobileAppCategoryCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new MobileAppCategoryCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppCategoryCollectionWithReferencesPage page = new MobileAppCategoryCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

