/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedMobileApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedMobileAppCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedMobileAppCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedMobileAppCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedMobileAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedMobileAppCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedMobileAppRequestBuilder;
import java.util.List;

public class ManagedMobileAppCollectionRequest
extends BaseCollectionRequest<ManagedMobileAppCollectionResponse, IManagedMobileAppCollectionPage>
implements IManagedMobileAppCollectionRequest {
    public ManagedMobileAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedMobileAppCollectionResponse.class, IManagedMobileAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedMobileAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedMobileAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedMobileAppCollectionPage get() throws ClientException {
        ManagedMobileAppCollectionResponse response = (ManagedMobileAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedMobileApp newManagedMobileApp, ICallback<ManagedMobileApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedMobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedMobileApp, callback);
    }

    @Override
    public ManagedMobileApp post(ManagedMobileApp newManagedMobileApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedMobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedMobileApp);
    }

    @Override
    public IManagedMobileAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedMobileAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedMobileAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedMobileAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedMobileAppCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedMobileAppCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedMobileAppCollectionPage buildFromResponse(ManagedMobileAppCollectionResponse response) {
        ManagedMobileAppCollectionRequestBuilder builder = response.nextLink != null ? new ManagedMobileAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedMobileAppCollectionPage page = new ManagedMobileAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

