/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedEBookAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedEBookAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedEBookAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentRequestBuilder;
import java.util.List;

public class ManagedEBookAssignmentCollectionRequest
extends BaseCollectionRequest<ManagedEBookAssignmentCollectionResponse, IManagedEBookAssignmentCollectionPage>
implements IManagedEBookAssignmentCollectionRequest {
    public ManagedEBookAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedEBookAssignmentCollectionResponse.class, IManagedEBookAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedEBookAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedEBookAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedEBookAssignmentCollectionPage get() throws ClientException {
        ManagedEBookAssignmentCollectionResponse response = (ManagedEBookAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedEBookAssignment newManagedEBookAssignment, ICallback<ManagedEBookAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedEBookAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedEBookAssignment, callback);
    }

    @Override
    public ManagedEBookAssignment post(ManagedEBookAssignment newManagedEBookAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedEBookAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedEBookAssignment);
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedEBookAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedEBookAssignmentCollectionPage buildFromResponse(ManagedEBookAssignmentCollectionResponse response) {
        ManagedEBookAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new ManagedEBookAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedEBookAssignmentCollectionPage page = new ManagedEBookAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

