/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ItemAnalytics;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemAnalyticsWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class ItemAnalyticsWithReferenceRequest
extends BaseRequest
implements IItemAnalyticsWithReferenceRequest {
    public ItemAnalyticsWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAnalytics.class);
    }

    @Override
    public void post(ItemAnalytics newItemAnalytics, IJsonBackedObject payload, ICallback<ItemAnalytics> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public ItemAnalytics post(ItemAnalytics newItemAnalytics, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newItemAnalytics;
        }
        return null;
    }

    @Override
    public void get(ICallback<ItemAnalytics> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ItemAnalytics get() throws ClientException {
        return (ItemAnalytics)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ItemAnalytics> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ItemAnalytics sourceItemAnalytics, ICallback<ItemAnalytics> callback) {
        this.send(HttpMethod.PATCH, callback, sourceItemAnalytics);
    }

    @Override
    public ItemAnalytics patch(ItemAnalytics sourceItemAnalytics) throws ClientException {
        return (ItemAnalytics)this.send(HttpMethod.PATCH, sourceItemAnalytics);
    }

    @Override
    public IItemAnalyticsWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemAnalyticsWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IItemAnalyticsWithReferenceRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

