/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.GroupLifecyclePolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupLifecyclePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupLifecyclePolicyCollectionRequest;
import java.util.List;

public class GroupLifecyclePolicyCollectionRequest
extends BaseCollectionRequest<GroupLifecyclePolicyCollectionResponse, IGroupLifecyclePolicyCollectionPage>
implements IGroupLifecyclePolicyCollectionRequest {
    public GroupLifecyclePolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupLifecyclePolicyCollectionResponse.class, IGroupLifecyclePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupLifecyclePolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupLifecyclePolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupLifecyclePolicyCollectionPage get() throws ClientException {
        GroupLifecyclePolicyCollectionResponse response = (GroupLifecyclePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupLifecyclePolicy newGroupLifecyclePolicy, ICallback<GroupLifecyclePolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupLifecyclePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupLifecyclePolicy, callback);
    }

    @Override
    public GroupLifecyclePolicy post(GroupLifecyclePolicy newGroupLifecyclePolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupLifecyclePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupLifecyclePolicy);
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IGroupLifecyclePolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IGroupLifecyclePolicyCollectionPage buildFromResponse(GroupLifecyclePolicyCollectionResponse response) {
        GroupLifecyclePolicyCollectionRequestBuilder builder = response.nextLink != null ? new GroupLifecyclePolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupLifecyclePolicyCollectionPage page = new GroupLifecyclePolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

