/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.FileAttachment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IFileAttachmentRequest;
import java.util.List;

public class FileAttachmentRequest
extends BaseRequest
implements IFileAttachmentRequest {
    public FileAttachmentRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, FileAttachment.class);
    }

    @Override
    public void get(ICallback<FileAttachment> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public FileAttachment get() throws ClientException {
        return (FileAttachment)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<FileAttachment> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(FileAttachment sourceFileAttachment, ICallback<FileAttachment> callback) {
        this.send(HttpMethod.PATCH, callback, sourceFileAttachment);
    }

    @Override
    public FileAttachment patch(FileAttachment sourceFileAttachment) throws ClientException {
        return (FileAttachment)this.send(HttpMethod.PATCH, sourceFileAttachment);
    }

    @Override
    public void post(FileAttachment newFileAttachment, ICallback<FileAttachment> callback) {
        this.send(HttpMethod.POST, callback, newFileAttachment);
    }

    @Override
    public FileAttachment post(FileAttachment newFileAttachment) throws ClientException {
        return (FileAttachment)this.send(HttpMethod.POST, newFileAttachment);
    }

    @Override
    public void put(FileAttachment newFileAttachment, ICallback<FileAttachment> callback) {
        this.send(HttpMethod.PUT, callback, newFileAttachment);
    }

    @Override
    public FileAttachment put(FileAttachment newFileAttachment) throws ClientException {
        return (FileAttachment)this.send(HttpMethod.PUT, newFileAttachment);
    }

    @Override
    public IFileAttachmentRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IFileAttachmentRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IFileAttachmentRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

