/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ExtensionProperty;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ExtensionPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.ExtensionPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionPropertyCollectionResponse;
import com.microsoft.graph.requests.extensions.ExtensionPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.IExtensionPropertyCollectionRequest;
import java.util.List;

public class ExtensionPropertyCollectionRequest
extends BaseCollectionRequest<ExtensionPropertyCollectionResponse, IExtensionPropertyCollectionPage>
implements IExtensionPropertyCollectionRequest {
    public ExtensionPropertyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExtensionPropertyCollectionResponse.class, IExtensionPropertyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IExtensionPropertyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ExtensionPropertyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IExtensionPropertyCollectionPage get() throws ClientException {
        ExtensionPropertyCollectionResponse response = (ExtensionPropertyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ExtensionProperty newExtensionProperty, ICallback<ExtensionProperty> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ExtensionPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newExtensionProperty, callback);
    }

    @Override
    public ExtensionProperty post(ExtensionProperty newExtensionProperty) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExtensionPropertyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newExtensionProperty);
    }

    @Override
    public IExtensionPropertyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IExtensionPropertyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IExtensionPropertyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IExtensionPropertyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IExtensionPropertyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IExtensionPropertyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IExtensionPropertyCollectionPage buildFromResponse(ExtensionPropertyCollectionResponse response) {
        ExtensionPropertyCollectionRequestBuilder builder = response.nextLink != null ? new ExtensionPropertyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ExtensionPropertyCollectionPage page = new ExtensionPropertyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

