/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Endpoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EndpointCollectionPage;
import com.microsoft.graph.requests.extensions.EndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EndpointCollectionResponse;
import com.microsoft.graph.requests.extensions.EndpointRequestBuilder;
import com.microsoft.graph.requests.extensions.IEndpointCollectionPage;
import com.microsoft.graph.requests.extensions.IEndpointCollectionRequest;
import java.util.List;

public class EndpointCollectionRequest
extends BaseCollectionRequest<EndpointCollectionResponse, IEndpointCollectionPage>
implements IEndpointCollectionRequest {
    public EndpointCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EndpointCollectionResponse.class, IEndpointCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEndpointCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EndpointCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEndpointCollectionPage get() throws ClientException {
        EndpointCollectionResponse response = (EndpointCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Endpoint newEndpoint, ICallback<Endpoint> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEndpoint, callback);
    }

    @Override
    public Endpoint post(Endpoint newEndpoint) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEndpoint);
    }

    @Override
    public IEndpointCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEndpointCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IEndpointCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEndpointCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEndpointCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IEndpointCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IEndpointCollectionPage buildFromResponse(EndpointCollectionResponse response) {
        EndpointCollectionRequestBuilder builder = response.nextLink != null ? new EndpointCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EndpointCollectionPage page = new EndpointCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

