/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.DriveItemRestoreBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDriveItemRestoreRequest;
import java.util.List;

public class DriveItemRestoreRequest
extends BaseRequest
implements IDriveItemRestoreRequest {
    protected final DriveItemRestoreBody body = new DriveItemRestoreBody();

    public DriveItemRestoreRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItem.class);
    }

    @Override
    public void post(ICallback<DriveItem> callback) {
        this.send(HttpMethod.POST, callback, this.body);
    }

    @Override
    public DriveItem post() throws ClientException {
        return (DriveItem)this.send(HttpMethod.POST, this.body);
    }

    @Override
    public IDriveItemRestoreRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemRestoreRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemRestoreRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IDriveItemRestoreRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

