/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceSettingState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionRequest;
import java.util.List;

public class DeviceComplianceSettingStateCollectionRequest
extends BaseCollectionRequest<DeviceComplianceSettingStateCollectionResponse, IDeviceComplianceSettingStateCollectionPage>
implements IDeviceComplianceSettingStateCollectionRequest {
    public DeviceComplianceSettingStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceSettingStateCollectionResponse.class, IDeviceComplianceSettingStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceSettingStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceSettingStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceSettingStateCollectionPage get() throws ClientException {
        DeviceComplianceSettingStateCollectionResponse response = (DeviceComplianceSettingStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceSettingState newDeviceComplianceSettingState, ICallback<DeviceComplianceSettingState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceSettingState, callback);
    }

    @Override
    public DeviceComplianceSettingState post(DeviceComplianceSettingState newDeviceComplianceSettingState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceSettingState);
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceComplianceSettingStateCollectionPage buildFromResponse(DeviceComplianceSettingStateCollectionResponse response) {
        DeviceComplianceSettingStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceSettingStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceSettingStateCollectionPage page = new DeviceComplianceSettingStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

