/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyStateCollectionRequest;
import java.util.List;

public class DeviceCompliancePolicyStateCollectionRequest
extends BaseCollectionRequest<DeviceCompliancePolicyStateCollectionResponse, IDeviceCompliancePolicyStateCollectionPage>
implements IDeviceCompliancePolicyStateCollectionRequest {
    public DeviceCompliancePolicyStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCompliancePolicyStateCollectionResponse.class, IDeviceCompliancePolicyStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCompliancePolicyStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceCompliancePolicyStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionPage get() throws ClientException {
        DeviceCompliancePolicyStateCollectionResponse response = (DeviceCompliancePolicyStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCompliancePolicyState newDeviceCompliancePolicyState, ICallback<DeviceCompliancePolicyState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCompliancePolicyStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceCompliancePolicyState, callback);
    }

    @Override
    public DeviceCompliancePolicyState post(DeviceCompliancePolicyState newDeviceCompliancePolicyState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCompliancePolicyStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceCompliancePolicyState);
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceCompliancePolicyStateCollectionPage buildFromResponse(DeviceCompliancePolicyStateCollectionResponse response) {
        DeviceCompliancePolicyStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCompliancePolicyStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCompliancePolicyStateCollectionPage page = new DeviceCompliancePolicyStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

