/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.CommsOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionPage;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.CommsOperationRequestBuilder;
import com.microsoft.graph.requests.extensions.ICommsOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ICommsOperationCollectionRequest;
import java.util.List;

public class CommsOperationCollectionRequest
extends BaseCollectionRequest<CommsOperationCollectionResponse, ICommsOperationCollectionPage>
implements ICommsOperationCollectionRequest {
    public CommsOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CommsOperationCollectionResponse.class, ICommsOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICommsOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CommsOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICommsOperationCollectionPage get() throws ClientException {
        CommsOperationCollectionResponse response = (CommsOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CommsOperation newCommsOperation, ICallback<CommsOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CommsOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCommsOperation, callback);
    }

    @Override
    public CommsOperation post(CommsOperation newCommsOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CommsOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCommsOperation);
    }

    @Override
    public ICommsOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICommsOperationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ICommsOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICommsOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICommsOperationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICommsOperationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICommsOperationCollectionPage buildFromResponse(CommsOperationCollectionResponse response) {
        CommsOperationCollectionRequestBuilder builder = response.nextLink != null ? new CommsOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CommsOperationCollectionPage page = new CommsOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

