/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.Extension;
import com.microsoft.graph.models.extensions.ScopedRoleMembership;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionResponse;
import com.microsoft.graph.requests.extensions.ExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.ExtensionCollectionResponse;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionPage;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class AdministrativeUnit
extends DirectoryObject
implements IJsonBackedObject {
    @SerializedName(value="description")
    @Expose
    public String description;
    @SerializedName(value="displayName")
    @Expose
    public String displayName;
    @SerializedName(value="visibility")
    @Expose
    public String visibility;
    public DirectoryObjectCollectionPage members;
    @SerializedName(value="scopedRoleMembers")
    @Expose
    public ScopedRoleMembershipCollectionPage scopedRoleMembers;
    @SerializedName(value="extensions")
    @Expose
    public ExtensionCollectionPage extensions;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Entity[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("members")) {
            response = new DirectoryObjectCollectionResponse();
            if (json.has("members@odata.nextLink")) {
                response.nextLink = json.get("members@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("members").toString(), JsonObject[].class);
            array = new DirectoryObject[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DirectoryObject.class);
                ((DirectoryObject)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.members = new DirectoryObjectCollectionPage((DirectoryObjectCollectionResponse)response, null);
        }
        if (json.has("scopedRoleMembers")) {
            response = new ScopedRoleMembershipCollectionResponse();
            if (json.has("scopedRoleMembers@odata.nextLink")) {
                ((ScopedRoleMembershipCollectionResponse)response).nextLink = json.get("scopedRoleMembers@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("scopedRoleMembers").toString(), JsonObject[].class);
            array = new ScopedRoleMembership[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ScopedRoleMembership.class);
                ((ScopedRoleMembership)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((ScopedRoleMembershipCollectionResponse)response).value = Arrays.asList(array);
            this.scopedRoleMembers = new ScopedRoleMembershipCollectionPage((ScopedRoleMembershipCollectionResponse)response, null);
        }
        if (json.has("extensions")) {
            response = new ExtensionCollectionResponse();
            if (json.has("extensions@odata.nextLink")) {
                ((ExtensionCollectionResponse)response).nextLink = json.get("extensions@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("extensions").toString(), JsonObject[].class);
            array = new Extension[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Extension.class);
                ((Extension)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((ExtensionCollectionResponse)response).value = Arrays.asList(array);
            this.extensions = new ExtensionCollectionPage((ExtensionCollectionResponse)response, null);
        }
    }
}

