/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.HeaderOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlConnection
implements IConnection {
    private final HttpURLConnection connection;
    private HashMap<String, String> headers;

    public UrlConnection(IHttpRequest request) throws IOException {
        this.connection = (HttpURLConnection)request.getRequestUrl().openConnection();
        for (HeaderOption header : request.getHeaders()) {
            this.connection.addRequestProperty(header.getName(), header.getValue().toString());
        }
        this.connection.setUseCaches(request.getUseCaches());
        try {
            this.connection.setRequestMethod(request.getHttpMethod().toString());
        }
        catch (ProtocolException ignored) {
            this.connection.setRequestMethod(HttpMethod.POST.toString());
            this.connection.addRequestProperty("X-HTTP-Method-Override", request.getHttpMethod().toString());
            this.connection.addRequestProperty("X-HTTP-Method", request.getHttpMethod().toString());
        }
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.connection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.connection.addRequestProperty(headerName, headerValue);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connection.setDoOutput(true);
        return this.connection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        int httpClientErrorResponseCode = 400;
        if (this.connection.getResponseCode() >= 400) {
            return this.connection.getErrorStream();
        }
        return this.connection.getInputStream();
    }

    @Override
    public int getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
        headerFields.putAll(this.connection.getHeaderFields());
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.add(String.format("%d", this.connection.getResponseCode()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid connection response code: could not connect to server", e);
        }
        headerFields.put("responseCode", list);
        return headerFields;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    public void close() {
        this.connection.disconnect();
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = UrlConnection.getResponseHeaders(this.connection);
        }
        return this.headers;
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public void setContentLength(int length) {
        this.connection.setFixedLengthStreamingMode(length);
    }

    @Override
    public void setReadTimeout(int readTimeoutMilliseconds) {
        this.connection.setReadTimeout(readTimeoutMilliseconds);
    }

    @Override
    public void setConnectTimeout(int connectTimeoutMilliseconds) {
        this.connection.setConnectTimeout(connectTimeoutMilliseconds);
    }

    private static HashMap<String, String> getResponseHeaders(HttpURLConnection connection) {
        HashMap<String, String> headers = new HashMap<String, String>();
        int index = 0;
        while (true) {
            String headerName = connection.getHeaderFieldKey(index);
            String headerValue = connection.getHeaderField(index);
            if (headerName == null && headerValue == null) break;
            headers.put(headerName, headerValue);
            ++index;
        }
        return headers;
    }
}

