/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.DefaultConnectionConfig;
import com.microsoft.graph.core.IConnectionConfig;
import com.microsoft.graph.http.DefaultConnectionFactory;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IConnectionFactory;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import okhttp3.Request;

public class DefaultHttpProvider
implements IHttpProvider {
    static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    static final String JSON_CONTENT_TYPE = "application/json";
    static final String JSON_ENCODING = "UTF-8";
    private final ISerializer serializer;
    private final IAuthenticationProvider authenticationProvider;
    private final IExecutors executors;
    private final ILogger logger;
    private IConnectionFactory connectionFactory;
    private IConnectionConfig connectionConfig;

    public DefaultHttpProvider(ISerializer serializer, IAuthenticationProvider authenticationProvider, IExecutors executors, ILogger logger) {
        this(serializer, authenticationProvider, executors, logger, new DefaultConnectionFactory());
    }

    public DefaultHttpProvider(ISerializer serializer, IAuthenticationProvider authenticationProvider, IExecutors executors, ILogger logger, IConnectionFactory connectionFactory) {
        this.serializer = serializer;
        this.authenticationProvider = authenticationProvider;
        this.executors = executors;
        this.logger = logger;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public ISerializer getSerializer() {
        return this.serializer;
    }

    public <Result, Body> void send(final IHttpRequest request, final ICallback<Result> callback, final Class<Result> resultClass, final Body serializable) {
        final IProgressCallback progressCallback = callback instanceof IProgressCallback ? (IProgressCallback)callback : null;
        this.executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultHttpProvider.this.executors.performOnForeground(DefaultHttpProvider.this.sendRequestInternal(request, resultClass, serializable, progressCallback, null), callback);
                }
                catch (ClientException e) {
                    DefaultHttpProvider.this.executors.performOnForeground(e, callback);
                }
            }
        });
    }

    public <Result, Body> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable) throws ClientException {
        return this.send(request, resultClass, serializable, (IStatefulResponseHandler<Result, DeserializeType>)null);
    }

    public <Result, Body, DeserializeType> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable, IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        return this.sendRequestInternal(request, resultClass, serializable, null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result, Body, DeserializeType> Result sendRequestInternal(IHttpRequest request, Class<Result> resultClass, Body serializable, IProgressCallback<Result> progress, IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        int defaultBufferSize = 4096;
        String binaryContentType = "application/octet-stream";
        try {
            if (this.authenticationProvider != null) {
                this.authenticationProvider.authenticateRequest(request);
            }
            OutputStream out = null;
            InputStream in = null;
            boolean isBinaryStreamInput = false;
            URL requestUrl = request.getRequestUrl();
            this.logger.logDebug("Starting to send request, URL " + requestUrl.toString());
            IConnection connection = this.connectionFactory.createFromRequest(request);
            if (this.connectionConfig == null) {
                this.connectionConfig = new DefaultConnectionConfig();
            }
            connection.setConnectTimeout(this.connectionConfig.getConnectTimeout());
            connection.setReadTimeout(this.connectionConfig.getReadTimeout());
            try {
                Result writtenSoFar2;
                byte[] bytesToWrite;
                this.logger.logDebug("Request Method " + request.getHttpMethod().toString());
                List<HeaderOption> requestHeaders = request.getHeaders();
                connection.addRequestHeader("Accept", "*/*");
                if (serializable == null) {
                    bytesToWrite = request.getHttpMethod() == HttpMethod.POST ? new byte[]{} : null;
                } else if (serializable instanceof byte[]) {
                    this.logger.logDebug("Sending byte[] as request body");
                    bytesToWrite = (byte[])serializable;
                    if (!DefaultHttpProvider.hasHeader(requestHeaders, CONTENT_TYPE_HEADER_NAME)) {
                        connection.addRequestHeader(CONTENT_TYPE_HEADER_NAME, "application/octet-stream");
                    }
                    connection.setContentLength(bytesToWrite.length);
                } else {
                    this.logger.logDebug("Sending " + serializable.getClass().getName() + " as request body");
                    String serializeObject = this.serializer.serializeObject(serializable);
                    bytesToWrite = serializeObject.getBytes(JSON_ENCODING);
                    if (!DefaultHttpProvider.hasHeader(requestHeaders, CONTENT_TYPE_HEADER_NAME)) {
                        connection.addRequestHeader(CONTENT_TYPE_HEADER_NAME, JSON_CONTENT_TYPE);
                    }
                    connection.setContentLength(bytesToWrite.length);
                }
                if (bytesToWrite != null) {
                    int toWrite;
                    out = connection.getOutputStream();
                    int writtenSoFar2 = 0;
                    BufferedOutputStream bos = new BufferedOutputStream(out);
                    do {
                        toWrite = Math.min(4096, bytesToWrite.length - writtenSoFar2);
                        bos.write(bytesToWrite, writtenSoFar2, toWrite);
                        writtenSoFar2 += toWrite;
                        if (progress == null) continue;
                        this.executors.performOnForeground(writtenSoFar2, bytesToWrite.length, progress);
                    } while (toWrite > 0);
                    bos.close();
                }
                if (handler != null) {
                    handler.configConnection(connection);
                }
                this.logger.logDebug(String.format("Response code %d, %s", connection.getResponseCode(), connection.getResponseMessage()));
                if (handler != null) {
                    this.logger.logDebug("StatefulResponse is handling the HTTP response.");
                    writtenSoFar2 = handler.generateResult(request, connection, this.getSerializer(), this.logger);
                    return writtenSoFar2;
                }
                if (connection.getResponseCode() >= 400) {
                    this.logger.logDebug("Handling error response");
                    in = connection.getInputStream();
                    this.handleErrorResponse(request, serializable, connection);
                }
                if (connection.getResponseCode() == 204 || connection.getResponseCode() == 304) {
                    this.logger.logDebug("Handling response with no body");
                    writtenSoFar2 = this.handleEmptyResponse(connection.getResponseHeaders(), resultClass);
                    return writtenSoFar2;
                }
                if (connection.getResponseCode() == 202) {
                    this.logger.logDebug("Handling accepted response");
                    writtenSoFar2 = this.handleEmptyResponse(connection.getResponseHeaders(), resultClass);
                    return writtenSoFar2;
                }
                in = new BufferedInputStream(connection.getInputStream());
                Map<String, String> headers = connection.getHeaders();
                String contentType = headers.get(CONTENT_TYPE_HEADER_NAME);
                if (contentType.contains(JSON_CONTENT_TYPE)) {
                    this.logger.logDebug("Response json");
                    Result Result = this.handleJsonResponse(in, connection.getResponseHeaders(), resultClass);
                    return Result;
                }
                this.logger.logDebug("Response binary");
                isBinaryStreamInput = true;
                InputStream inputStream = this.handleBinaryStream(in);
                return (Result)inputStream;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (!isBinaryStreamInput && in != null) {
                    in.close();
                    connection.close();
                }
            }
        }
        catch (GraphServiceException ex) {
            boolean shouldLogVerbosely = this.logger.getLoggingLevel() == LoggerLevel.DEBUG;
            this.logger.logError("Graph service exception " + ex.getMessage(shouldLogVerbosely), ex);
            throw ex;
        }
        catch (UnsupportedEncodingException ex) {
            ClientException clientException = new ClientException("Unsupported encoding problem: ", ex);
            this.logger.logError("Unsupported encoding problem: " + ex.getMessage(), ex);
            throw clientException;
        }
        catch (Exception ex) {
            ClientException clientException = new ClientException("Error during http request", ex);
            this.logger.logError("Error during http request", clientException);
            throw clientException;
        }
    }

    private <Body> void handleErrorResponse(IHttpRequest request, Body serializable, IConnection connection) throws IOException {
        throw GraphServiceException.createFromConnection(request, serializable, this.serializer, connection, this.logger);
    }

    private InputStream handleBinaryStream(InputStream in) {
        return in;
    }

    private <Result> Result handleJsonResponse(InputStream in, Map<String, List<String>> responseHeaders, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        String rawJson = DefaultHttpProvider.streamToString(in);
        return this.getSerializer().deserializeObject(rawJson, clazz, responseHeaders);
    }

    private <Result> Result handleEmptyResponse(Map<String, List<String>> responseHeaders, Class<Result> clazz) throws UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream("{}".getBytes(JSON_ENCODING));
        return this.handleJsonResponse(in, responseHeaders, clazz);
    }

    void setConnectionFactory(IConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream input) {
        String httpStreamEncoding = JSON_ENCODING;
        String endOfFile = "\\A";
        String scannerString = "";
        try (Scanner scanner = new Scanner(input, JSON_ENCODING);){
            scanner.useDelimiter("\\A");
            scannerString = scanner.next();
        }
        return scannerString;
    }

    @VisibleForTesting
    static boolean hasHeader(List<HeaderOption> headers, String header) {
        for (HeaderOption option : headers) {
            if (!option.getName().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public ILogger getLogger() {
        return this.logger;
    }

    @VisibleForTesting
    public IExecutors getExecutors() {
        return this.executors;
    }

    @VisibleForTesting
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    @Override
    public IConnectionConfig getConnectionConfig() {
        if (this.connectionConfig == null) {
            this.connectionConfig = new DefaultConnectionConfig();
        }
        return this.connectionConfig;
    }

    @Override
    public void setConnectionConfig(IConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    @Override
    public <Result, BodyType> Request getHttpRequest(IHttpRequest request, Class<Result> resultClass, BodyType serializable, IProgressCallback<Result> progress) throws ClientException {
        return null;
    }
}

