/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests.extensions;

import com.microsoft.graph.callrecords.models.extensions.Segment;
import com.microsoft.graph.callrecords.requests.extensions.ISegmentRequest;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class SegmentRequest
extends BaseRequest
implements ISegmentRequest {
    public SegmentRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Segment.class);
    }

    @Override
    public void get(ICallback<Segment> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Segment get() throws ClientException {
        return (Segment)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Segment> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Segment sourceSegment, ICallback<Segment> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSegment);
    }

    @Override
    public Segment patch(Segment sourceSegment) throws ClientException {
        return (Segment)this.send(HttpMethod.PATCH, sourceSegment);
    }

    @Override
    public void post(Segment newSegment, ICallback<Segment> callback) {
        this.send(HttpMethod.POST, callback, newSegment);
    }

    @Override
    public Segment post(Segment newSegment) throws ClientException {
        return (Segment)this.send(HttpMethod.POST, newSegment);
    }

    @Override
    public void put(Segment newSegment, ICallback<Segment> callback) {
        this.send(HttpMethod.PUT, callback, newSegment);
    }

    @Override
    public Segment put(Segment newSegment) throws ClientException {
        return (Segment)this.send(HttpMethod.PUT, newSegment);
    }

    @Override
    public ISegmentRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISegmentRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public ISegmentRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

