// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TermsAndConditions;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAcceptanceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAcceptanceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAcceptanceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAcceptanceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Terms And Conditions Request.
 */
public class TermsAndConditionsRequest extends BaseRequest implements ITermsAndConditionsRequest {
	
    /**
     * The request for the TermsAndConditions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermsAndConditionsRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TermsAndConditions.class);
    }

    /**
     * Gets the TermsAndConditions from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TermsAndConditions from the service
     *
     * @return the TermsAndConditions from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TermsAndConditions get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TermsAndConditions with a source
     *
     * @param sourceTermsAndConditions the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TermsAndConditions sourceTermsAndConditions, final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.PATCH, callback, sourceTermsAndConditions);
    }

    /**
     * Patches this TermsAndConditions with a source
     *
     * @param sourceTermsAndConditions the source object with updates
     * @return the updated TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TermsAndConditions patch(final TermsAndConditions sourceTermsAndConditions) throws ClientException {
        return send(HttpMethod.PATCH, sourceTermsAndConditions);
    }

    /**
     * Creates a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TermsAndConditions newTermsAndConditions, final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.POST, callback, newTermsAndConditions);
    }

    /**
     * Creates a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the new object to create
     * @return the created TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TermsAndConditions post(final TermsAndConditions newTermsAndConditions) throws ClientException {
        return send(HttpMethod.POST, newTermsAndConditions);
    }

    /**
     * Creates a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TermsAndConditions newTermsAndConditions, final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.PUT, callback, newTermsAndConditions);
    }

    /**
     * Creates a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the object to create/update
     * @return the created TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TermsAndConditions put(final TermsAndConditions newTermsAndConditions) throws ClientException {
        return send(HttpMethod.PUT, newTermsAndConditions);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITermsAndConditionsRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TermsAndConditionsRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITermsAndConditionsRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TermsAndConditionsRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public ITermsAndConditionsRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (TermsAndConditionsRequest)this;
     }

}

