// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SecureScoreControlProfile;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Secure Score Control Profile Request.
 */
public class SecureScoreControlProfileRequest extends BaseRequest implements ISecureScoreControlProfileRequest {
	
    /**
     * The request for the SecureScoreControlProfile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SecureScoreControlProfileRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreControlProfile.class);
    }

    /**
     * Gets the SecureScoreControlProfile from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<SecureScoreControlProfile> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SecureScoreControlProfile from the service
     *
     * @return the SecureScoreControlProfile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SecureScoreControlProfile get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<SecureScoreControlProfile> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SecureScoreControlProfile with a source
     *
     * @param sourceSecureScoreControlProfile the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SecureScoreControlProfile sourceSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback) {
        send(HttpMethod.PATCH, callback, sourceSecureScoreControlProfile);
    }

    /**
     * Patches this SecureScoreControlProfile with a source
     *
     * @param sourceSecureScoreControlProfile the source object with updates
     * @return the updated SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SecureScoreControlProfile patch(final SecureScoreControlProfile sourceSecureScoreControlProfile) throws ClientException {
        return send(HttpMethod.PATCH, sourceSecureScoreControlProfile);
    }

    /**
     * Creates a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SecureScoreControlProfile newSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback) {
        send(HttpMethod.POST, callback, newSecureScoreControlProfile);
    }

    /**
     * Creates a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the new object to create
     * @return the created SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SecureScoreControlProfile post(final SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException {
        return send(HttpMethod.POST, newSecureScoreControlProfile);
    }

    /**
     * Creates a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final SecureScoreControlProfile newSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback) {
        send(HttpMethod.PUT, callback, newSecureScoreControlProfile);
    }

    /**
     * Creates a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the object to create/update
     * @return the created SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SecureScoreControlProfile put(final SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException {
        return send(HttpMethod.PUT, newSecureScoreControlProfile);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISecureScoreControlProfileRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (SecureScoreControlProfileRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISecureScoreControlProfileRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (SecureScoreControlProfileRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public ISecureScoreControlProfileRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (SecureScoreControlProfileRequest)this;
     }

}

