// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MobileLobApp;
import com.microsoft.graph.requests.extensions.IMobileAppContentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMobileAppContentRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile Lob App Request.
 */
public class MobileLobAppRequest extends BaseRequest implements IMobileLobAppRequest {
	
    /**
     * The request for the MobileLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public MobileLobAppRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends MobileLobApp> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the MobileLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileLobAppRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileLobApp.class);
    }

    /**
     * Gets the MobileLobApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<MobileLobApp> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the MobileLobApp from the service
     *
     * @return the MobileLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MobileLobApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<MobileLobApp> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MobileLobApp with a source
     *
     * @param sourceMobileLobApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final MobileLobApp sourceMobileLobApp, final ICallback<MobileLobApp> callback) {
        send(HttpMethod.PATCH, callback, sourceMobileLobApp);
    }

    /**
     * Patches this MobileLobApp with a source
     *
     * @param sourceMobileLobApp the source object with updates
     * @return the updated MobileLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MobileLobApp patch(final MobileLobApp sourceMobileLobApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMobileLobApp);
    }

    /**
     * Creates a MobileLobApp with a new object
     *
     * @param newMobileLobApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final MobileLobApp newMobileLobApp, final ICallback<MobileLobApp> callback) {
        send(HttpMethod.POST, callback, newMobileLobApp);
    }

    /**
     * Creates a MobileLobApp with a new object
     *
     * @param newMobileLobApp the new object to create
     * @return the created MobileLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MobileLobApp post(final MobileLobApp newMobileLobApp) throws ClientException {
        return send(HttpMethod.POST, newMobileLobApp);
    }

    /**
     * Creates a MobileLobApp with a new object
     *
     * @param newMobileLobApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final MobileLobApp newMobileLobApp, final ICallback<MobileLobApp> callback) {
        send(HttpMethod.PUT, callback, newMobileLobApp);
    }

    /**
     * Creates a MobileLobApp with a new object
     *
     * @param newMobileLobApp the object to create/update
     * @return the created MobileLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MobileLobApp put(final MobileLobApp newMobileLobApp) throws ClientException {
        return send(HttpMethod.PUT, newMobileLobApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IMobileLobAppRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (MobileLobAppRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IMobileLobAppRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (MobileLobAppRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IMobileLobAppRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (MobileLobAppRequest)this;
     }

}

