// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.InformationProtection;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestRequestBuilder;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Information Protection Request.
 */
public class InformationProtectionRequest extends BaseRequest implements IInformationProtectionRequest {
	
    /**
     * The request for the InformationProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public InformationProtectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, InformationProtection.class);
    }

    /**
     * Gets the InformationProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<InformationProtection> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the InformationProtection from the service
     *
     * @return the InformationProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public InformationProtection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<InformationProtection> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this InformationProtection with a source
     *
     * @param sourceInformationProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final InformationProtection sourceInformationProtection, final ICallback<InformationProtection> callback) {
        send(HttpMethod.PATCH, callback, sourceInformationProtection);
    }

    /**
     * Patches this InformationProtection with a source
     *
     * @param sourceInformationProtection the source object with updates
     * @return the updated InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public InformationProtection patch(final InformationProtection sourceInformationProtection) throws ClientException {
        return send(HttpMethod.PATCH, sourceInformationProtection);
    }

    /**
     * Creates a InformationProtection with a new object
     *
     * @param newInformationProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final InformationProtection newInformationProtection, final ICallback<InformationProtection> callback) {
        send(HttpMethod.POST, callback, newInformationProtection);
    }

    /**
     * Creates a InformationProtection with a new object
     *
     * @param newInformationProtection the new object to create
     * @return the created InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public InformationProtection post(final InformationProtection newInformationProtection) throws ClientException {
        return send(HttpMethod.POST, newInformationProtection);
    }

    /**
     * Creates a InformationProtection with a new object
     *
     * @param newInformationProtection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final InformationProtection newInformationProtection, final ICallback<InformationProtection> callback) {
        send(HttpMethod.PUT, callback, newInformationProtection);
    }

    /**
     * Creates a InformationProtection with a new object
     *
     * @param newInformationProtection the object to create/update
     * @return the created InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public InformationProtection put(final InformationProtection newInformationProtection) throws ClientException {
        return send(HttpMethod.PUT, newInformationProtection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IInformationProtectionRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (InformationProtectionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IInformationProtectionRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (InformationProtectionRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IInformationProtectionRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (InformationProtectionRequest)this;
     }

}

