// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.InviteParticipantsOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Invite Participants Operation Request.
 */
public interface IInviteParticipantsOperationRequest extends IHttpRequest {

    /**
     * Gets the InviteParticipantsOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<InviteParticipantsOperation> callback);

    /**
     * Gets the InviteParticipantsOperation from the service
     *
     * @return the InviteParticipantsOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InviteParticipantsOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<InviteParticipantsOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this InviteParticipantsOperation with a source
     *
     * @param sourceInviteParticipantsOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final InviteParticipantsOperation sourceInviteParticipantsOperation, final ICallback<InviteParticipantsOperation> callback);

    /**
     * Patches this InviteParticipantsOperation with a source
     *
     * @param sourceInviteParticipantsOperation the source object with updates
     * @return the updated InviteParticipantsOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InviteParticipantsOperation patch(final InviteParticipantsOperation sourceInviteParticipantsOperation) throws ClientException;

    /**
     * Posts a InviteParticipantsOperation with a new object
     *
     * @param newInviteParticipantsOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final InviteParticipantsOperation newInviteParticipantsOperation, final ICallback<InviteParticipantsOperation> callback);

    /**
     * Posts a InviteParticipantsOperation with a new object
     *
     * @param newInviteParticipantsOperation the new object to create
     * @return the created InviteParticipantsOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InviteParticipantsOperation post(final InviteParticipantsOperation newInviteParticipantsOperation) throws ClientException;

    /**
     * Posts a InviteParticipantsOperation with a new object
     *
     * @param newInviteParticipantsOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final InviteParticipantsOperation newInviteParticipantsOperation, final ICallback<InviteParticipantsOperation> callback);

    /**
     * Posts a InviteParticipantsOperation with a new object
     *
     * @param newInviteParticipantsOperation the object to create/update
     * @return the created InviteParticipantsOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InviteParticipantsOperation put(final InviteParticipantsOperation newInviteParticipantsOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IInviteParticipantsOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IInviteParticipantsOperationRequest expand(final String value);

}

