// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DeviceComplianceSettingState;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Setting State Request.
 */
public class DeviceComplianceSettingStateRequest extends BaseRequest implements IDeviceComplianceSettingStateRequest {
	
    /**
     * The request for the DeviceComplianceSettingState
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceComplianceSettingStateRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceSettingState.class);
    }

    /**
     * Gets the DeviceComplianceSettingState from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DeviceComplianceSettingState> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DeviceComplianceSettingState from the service
     *
     * @return the DeviceComplianceSettingState from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceSettingState get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DeviceComplianceSettingState> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceComplianceSettingState with a source
     *
     * @param sourceDeviceComplianceSettingState the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DeviceComplianceSettingState sourceDeviceComplianceSettingState, final ICallback<DeviceComplianceSettingState> callback) {
        send(HttpMethod.PATCH, callback, sourceDeviceComplianceSettingState);
    }

    /**
     * Patches this DeviceComplianceSettingState with a source
     *
     * @param sourceDeviceComplianceSettingState the source object with updates
     * @return the updated DeviceComplianceSettingState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceSettingState patch(final DeviceComplianceSettingState sourceDeviceComplianceSettingState) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceComplianceSettingState);
    }

    /**
     * Creates a DeviceComplianceSettingState with a new object
     *
     * @param newDeviceComplianceSettingState the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DeviceComplianceSettingState newDeviceComplianceSettingState, final ICallback<DeviceComplianceSettingState> callback) {
        send(HttpMethod.POST, callback, newDeviceComplianceSettingState);
    }

    /**
     * Creates a DeviceComplianceSettingState with a new object
     *
     * @param newDeviceComplianceSettingState the new object to create
     * @return the created DeviceComplianceSettingState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceSettingState post(final DeviceComplianceSettingState newDeviceComplianceSettingState) throws ClientException {
        return send(HttpMethod.POST, newDeviceComplianceSettingState);
    }

    /**
     * Creates a DeviceComplianceSettingState with a new object
     *
     * @param newDeviceComplianceSettingState the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final DeviceComplianceSettingState newDeviceComplianceSettingState, final ICallback<DeviceComplianceSettingState> callback) {
        send(HttpMethod.PUT, callback, newDeviceComplianceSettingState);
    }

    /**
     * Creates a DeviceComplianceSettingState with a new object
     *
     * @param newDeviceComplianceSettingState the object to create/update
     * @return the created DeviceComplianceSettingState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceSettingState put(final DeviceComplianceSettingState newDeviceComplianceSettingState) throws ClientException {
        return send(HttpMethod.PUT, newDeviceComplianceSettingState);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDeviceComplianceSettingStateRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DeviceComplianceSettingStateRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDeviceComplianceSettingStateRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DeviceComplianceSettingStateRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IDeviceComplianceSettingStateRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (DeviceComplianceSettingStateRequest)this;
     }

}

