// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Calendar;
import com.microsoft.graph.requests.extensions.ICalendarSharingMessageAcceptRequest;
import com.microsoft.graph.requests.extensions.CalendarSharingMessageAcceptRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Sharing Message Accept Request.
 */
public class CalendarSharingMessageAcceptRequest extends BaseRequest implements ICalendarSharingMessageAcceptRequest {

    /**
     * The request for this CalendarSharingMessageAccept
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CalendarSharingMessageAcceptRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Calendar.class);
    }

    /**
     * Creates the CalendarSharingMessageAccept
     *
     * @param callback the callback to be called after success or failure
     */
    public void post(final ICallback<Calendar> callback) {
        send(HttpMethod.POST, callback, null);
    }

    /**
     * Creates the CalendarSharingMessageAccept
     *
     * @return the Calendar
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public Calendar post() throws ClientException {
       return send(HttpMethod.POST, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ICalendarSharingMessageAcceptRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (CalendarSharingMessageAcceptRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ICalendarSharingMessageAcceptRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (CalendarSharingMessageAcceptRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public ICalendarSharingMessageAcceptRequest filter(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (CalendarSharingMessageAcceptRequest)this;
    }

}
