/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class UserWithReferenceRequest
extends BaseRequest
implements IUserWithReferenceRequest {
    public UserWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, User.class);
    }

    @Override
    public void post(User newUser, IJsonBackedObject payload, ICallback<? super User> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public User post(User newUser, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newUser;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super User> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public User get() throws ClientException {
        return (User)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super User> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(User sourceUser, ICallback<? super User> callback) {
        this.send(HttpMethod.PATCH, callback, sourceUser);
    }

    @Override
    public User patch(User sourceUser) throws ClientException {
        return (User)this.send(HttpMethod.PATCH, sourceUser);
    }

    @Override
    public IUserWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

