/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintTaskDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionCollectionPage;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionRequestBuilder;
import java.util.List;

public class PrintTaskDefinitionCollectionRequest
extends BaseCollectionRequest<PrintTaskDefinitionCollectionResponse, IPrintTaskDefinitionCollectionPage>
implements IPrintTaskDefinitionCollectionRequest {
    public PrintTaskDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTaskDefinitionCollectionResponse.class, IPrintTaskDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintTaskDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintTaskDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintTaskDefinitionCollectionPage get() throws ClientException {
        PrintTaskDefinitionCollectionResponse response = (PrintTaskDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintTaskDefinition newPrintTaskDefinition, ICallback<? super PrintTaskDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintTaskDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTaskDefinition, callback);
    }

    @Override
    public PrintTaskDefinition post(PrintTaskDefinition newPrintTaskDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintTaskDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTaskDefinition);
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintTaskDefinitionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintTaskDefinitionCollectionPage buildFromResponse(PrintTaskDefinitionCollectionResponse response) {
        PrintTaskDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new PrintTaskDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintTaskDefinitionCollectionPage page = new PrintTaskDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

