/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.PrintConnector;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintConnectorWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class PrintConnectorWithReferenceRequest
extends BaseRequest
implements IPrintConnectorWithReferenceRequest {
    public PrintConnectorWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnector.class);
    }

    @Override
    public void post(PrintConnector newPrintConnector, IJsonBackedObject payload, ICallback<? super PrintConnector> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public PrintConnector post(PrintConnector newPrintConnector, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newPrintConnector;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super PrintConnector> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public PrintConnector get() throws ClientException {
        return (PrintConnector)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super PrintConnector> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(PrintConnector sourcePrintConnector, ICallback<? super PrintConnector> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePrintConnector);
    }

    @Override
    public PrintConnector patch(PrintConnector sourcePrintConnector) throws ClientException {
        return (PrintConnector)this.send(HttpMethod.PATCH, sourcePrintConnector);
    }

    @Override
    public IPrintConnectorWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintConnectorWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

