/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionWithReferencesRequestBuilder;
import java.util.List;

public class PrintConnectorCollectionWithReferencesRequest
extends BaseCollectionRequest<PrintConnectorCollectionResponse, IPrintConnectorCollectionPage>
implements IPrintConnectorCollectionWithReferencesRequest {
    public PrintConnectorCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnectorCollectionResponse.class, IPrintConnectorCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintConnectorCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintConnectorCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintConnectorCollectionWithReferencesPage get() throws ClientException {
        PrintConnectorCollectionResponse response = (PrintConnectorCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IPrintConnectorCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IPrintConnectorCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IPrintConnectorCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IPrintConnectorCollectionWithReferencesPage buildFromResponse(PrintConnectorCollectionResponse response) {
        PrintConnectorCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new PrintConnectorCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintConnectorCollectionWithReferencesPage page = new PrintConnectorCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

