/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintConnector;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintConnectorRequestBuilder;
import java.util.List;

public class PrintConnectorCollectionRequest
extends BaseCollectionRequest<PrintConnectorCollectionResponse, IPrintConnectorCollectionPage>
implements IPrintConnectorCollectionRequest {
    public PrintConnectorCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnectorCollectionResponse.class, IPrintConnectorCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintConnectorCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintConnectorCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintConnectorCollectionPage get() throws ClientException {
        PrintConnectorCollectionResponse response = (PrintConnectorCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintConnector newPrintConnector, ICallback<? super PrintConnector> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintConnector, callback);
    }

    @Override
    public PrintConnector post(PrintConnector newPrintConnector) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintConnector);
    }

    @Override
    public IPrintConnectorCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintConnectorCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintConnectorCollectionPage buildFromResponse(PrintConnectorCollectionResponse response) {
        PrintConnectorCollectionRequestBuilder builder = response.nextLink != null ? new PrintConnectorCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintConnectorCollectionPage page = new PrintConnectorCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

