/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOutlookUserSupportedLanguagesCollectionPage;
import com.microsoft.graph.requests.extensions.IOutlookUserSupportedLanguagesCollectionRequest;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedLanguagesCollectionPage;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedLanguagesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedLanguagesCollectionResponse;
import java.util.List;

public class OutlookUserSupportedLanguagesCollectionRequest
extends BaseCollectionRequest<OutlookUserSupportedLanguagesCollectionResponse, IOutlookUserSupportedLanguagesCollectionPage>
implements IOutlookUserSupportedLanguagesCollectionRequest {
    public OutlookUserSupportedLanguagesCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookUserSupportedLanguagesCollectionResponse.class, IOutlookUserSupportedLanguagesCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOutlookUserSupportedLanguagesCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OutlookUserSupportedLanguagesCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOutlookUserSupportedLanguagesCollectionPage get() throws ClientException {
        OutlookUserSupportedLanguagesCollectionResponse response = (OutlookUserSupportedLanguagesCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IOutlookUserSupportedLanguagesCollectionPage buildFromResponse(OutlookUserSupportedLanguagesCollectionResponse response) {
        OutlookUserSupportedLanguagesCollectionRequestBuilder builder = response.nextLink != null ? new OutlookUserSupportedLanguagesCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OutlookUserSupportedLanguagesCollectionPage page = new OutlookUserSupportedLanguagesCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IOutlookUserSupportedLanguagesCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOutlookUserSupportedLanguagesCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOutlookUserSupportedLanguagesCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IOutlookUserSupportedLanguagesCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IOutlookUserSupportedLanguagesCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

