/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OrganizationalBrandingLocalization;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOrganizationalBrandingLocalizationCollectionPage;
import com.microsoft.graph.requests.extensions.IOrganizationalBrandingLocalizationCollectionRequest;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationCollectionPage;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationCollectionResponse;
import com.microsoft.graph.requests.extensions.OrganizationalBrandingLocalizationRequestBuilder;
import java.util.List;

public class OrganizationalBrandingLocalizationCollectionRequest
extends BaseCollectionRequest<OrganizationalBrandingLocalizationCollectionResponse, IOrganizationalBrandingLocalizationCollectionPage>
implements IOrganizationalBrandingLocalizationCollectionRequest {
    public OrganizationalBrandingLocalizationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBrandingLocalizationCollectionResponse.class, IOrganizationalBrandingLocalizationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOrganizationalBrandingLocalizationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OrganizationalBrandingLocalizationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionPage get() throws ClientException {
        OrganizationalBrandingLocalizationCollectionResponse response = (OrganizationalBrandingLocalizationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OrganizationalBrandingLocalization newOrganizationalBrandingLocalization, ICallback<? super OrganizationalBrandingLocalization> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OrganizationalBrandingLocalizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOrganizationalBrandingLocalization, callback);
    }

    @Override
    public OrganizationalBrandingLocalization post(OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OrganizationalBrandingLocalizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOrganizationalBrandingLocalization);
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOrganizationalBrandingLocalizationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOrganizationalBrandingLocalizationCollectionPage buildFromResponse(OrganizationalBrandingLocalizationCollectionResponse response) {
        OrganizationalBrandingLocalizationCollectionRequestBuilder builder = response.nextLink != null ? new OrganizationalBrandingLocalizationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OrganizationalBrandingLocalizationCollectionPage page = new OrganizationalBrandingLocalizationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

