/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.LinkedResource;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ILinkedResourceCollectionPage;
import com.microsoft.graph.requests.extensions.ILinkedResourceCollectionRequest;
import com.microsoft.graph.requests.extensions.LinkedResourceCollectionPage;
import com.microsoft.graph.requests.extensions.LinkedResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.LinkedResourceCollectionResponse;
import com.microsoft.graph.requests.extensions.LinkedResourceRequestBuilder;
import java.util.List;

public class LinkedResourceCollectionRequest
extends BaseCollectionRequest<LinkedResourceCollectionResponse, ILinkedResourceCollectionPage>
implements ILinkedResourceCollectionRequest {
    public LinkedResourceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LinkedResourceCollectionResponse.class, ILinkedResourceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ILinkedResourceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(LinkedResourceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ILinkedResourceCollectionPage get() throws ClientException {
        LinkedResourceCollectionResponse response = (LinkedResourceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(LinkedResource newLinkedResource, ICallback<? super LinkedResource> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new LinkedResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newLinkedResource, callback);
    }

    @Override
    public LinkedResource post(LinkedResource newLinkedResource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LinkedResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newLinkedResource);
    }

    @Override
    public ILinkedResourceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ILinkedResourceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ILinkedResourceCollectionPage buildFromResponse(LinkedResourceCollectionResponse response) {
        LinkedResourceCollectionRequestBuilder builder = response.nextLink != null ? new LinkedResourceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        LinkedResourceCollectionPage page = new LinkedResourceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

