/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.IosManagedAppProtection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IIosManagedAppProtectionCollectionRequest;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionResponse;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionRequestBuilder;
import java.util.List;

public class IosManagedAppProtectionCollectionRequest
extends BaseCollectionRequest<IosManagedAppProtectionCollectionResponse, IIosManagedAppProtectionCollectionPage>
implements IIosManagedAppProtectionCollectionRequest {
    public IosManagedAppProtectionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosManagedAppProtectionCollectionResponse.class, IIosManagedAppProtectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IIosManagedAppProtectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(IosManagedAppProtectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIosManagedAppProtectionCollectionPage get() throws ClientException {
        IosManagedAppProtectionCollectionResponse response = (IosManagedAppProtectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IosManagedAppProtection newIosManagedAppProtection, ICallback<? super IosManagedAppProtection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIosManagedAppProtection, callback);
    }

    @Override
    public IosManagedAppProtection post(IosManagedAppProtection newIosManagedAppProtection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IosManagedAppProtectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIosManagedAppProtection);
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IIosManagedAppProtectionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IIosManagedAppProtectionCollectionPage buildFromResponse(IosManagedAppProtectionCollectionResponse response) {
        IosManagedAppProtectionCollectionRequestBuilder builder = response.nextLink != null ? new IosManagedAppProtectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IosManagedAppProtectionCollectionPage page = new IosManagedAppProtectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

