/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Endpoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IEndpointRequest;
import java.util.List;

public class EndpointRequest
extends BaseRequest
implements IEndpointRequest {
    public EndpointRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Endpoint.class);
    }

    @Override
    public void get(ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Endpoint get() throws ClientException {
        return (Endpoint)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Endpoint sourceEndpoint, ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.PATCH, callback, sourceEndpoint);
    }

    @Override
    public Endpoint patch(Endpoint sourceEndpoint) throws ClientException {
        return (Endpoint)this.send(HttpMethod.PATCH, sourceEndpoint);
    }

    @Override
    public void post(Endpoint newEndpoint, ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.POST, callback, newEndpoint);
    }

    @Override
    public Endpoint post(Endpoint newEndpoint) throws ClientException {
        return (Endpoint)this.send(HttpMethod.POST, newEndpoint);
    }

    @Override
    public void put(Endpoint newEndpoint, ICallback<? super Endpoint> callback) {
        this.send(HttpMethod.PUT, callback, newEndpoint);
    }

    @Override
    public Endpoint put(Endpoint newEndpoint) throws ClientException {
        return (Endpoint)this.send(HttpMethod.PUT, newEndpoint);
    }

    @Override
    public IEndpointRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEndpointRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

