/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ApplicationTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ApplicationTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.ApplicationTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ApplicationTemplateCollectionResponse;
import com.microsoft.graph.requests.extensions.ApplicationTemplateRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.IApplicationTemplateCollectionRequest;
import java.util.List;

public class ApplicationTemplateCollectionRequest
extends BaseCollectionRequest<ApplicationTemplateCollectionResponse, IApplicationTemplateCollectionPage>
implements IApplicationTemplateCollectionRequest {
    public ApplicationTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationTemplateCollectionResponse.class, IApplicationTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IApplicationTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ApplicationTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IApplicationTemplateCollectionPage get() throws ClientException {
        ApplicationTemplateCollectionResponse response = (ApplicationTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ApplicationTemplate newApplicationTemplate, ICallback<? super ApplicationTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ApplicationTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newApplicationTemplate, callback);
    }

    @Override
    public ApplicationTemplate post(ApplicationTemplate newApplicationTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ApplicationTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newApplicationTemplate);
    }

    @Override
    public IApplicationTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IApplicationTemplateCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IApplicationTemplateCollectionPage buildFromResponse(ApplicationTemplateCollectionResponse response) {
        ApplicationTemplateCollectionRequestBuilder builder = response.nextLink != null ? new ApplicationTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ApplicationTemplateCollectionPage page = new ApplicationTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

