// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintConnectorWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Request.
 */
public class PrinterRequest extends BaseRequest implements IPrinterRequest {
	
    /**
     * The request for the Printer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Printer.class);
    }

    /**
     * Gets the Printer from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super Printer> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Printer from the service
     *
     * @return the Printer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Printer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super Printer> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Printer with a source
     *
     * @param sourcePrinter the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Printer sourcePrinter, final ICallback<? super Printer> callback) {
        send(HttpMethod.PATCH, callback, sourcePrinter);
    }

    /**
     * Patches this Printer with a source
     *
     * @param sourcePrinter the source object with updates
     * @return the updated Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Printer patch(final Printer sourcePrinter) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrinter);
    }

    /**
     * Creates a Printer with a new object
     *
     * @param newPrinter the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Printer newPrinter, final ICallback<? super Printer> callback) {
        send(HttpMethod.POST, callback, newPrinter);
    }

    /**
     * Creates a Printer with a new object
     *
     * @param newPrinter the new object to create
     * @return the created Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Printer post(final Printer newPrinter) throws ClientException {
        return send(HttpMethod.POST, newPrinter);
    }

    /**
     * Creates a Printer with a new object
     *
     * @param newPrinter the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Printer newPrinter, final ICallback<? super Printer> callback) {
        send(HttpMethod.PUT, callback, newPrinter);
    }

    /**
     * Creates a Printer with a new object
     *
     * @param newPrinter the object to create/update
     * @return the created Printer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Printer put(final Printer newPrinter) throws ClientException {
        return send(HttpMethod.PUT, newPrinter);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrinterRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrinterRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrinterRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrinterRequest)this;
     }

}

