// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintUsage;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Usage Request.
 */
public class PrintUsageRequest extends BaseRequest implements IPrintUsageRequest {
	
    /**
     * The request for the PrintUsage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public PrintUsageRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends PrintUsage> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the PrintUsage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintUsageRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsage.class);
    }

    /**
     * Gets the PrintUsage from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrintUsage> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrintUsage from the service
     *
     * @return the PrintUsage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrintUsage> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintUsage with a source
     *
     * @param sourcePrintUsage the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrintUsage sourcePrintUsage, final ICallback<? super PrintUsage> callback) {
        send(HttpMethod.PATCH, callback, sourcePrintUsage);
    }

    /**
     * Patches this PrintUsage with a source
     *
     * @param sourcePrintUsage the source object with updates
     * @return the updated PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsage patch(final PrintUsage sourcePrintUsage) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintUsage);
    }

    /**
     * Creates a PrintUsage with a new object
     *
     * @param newPrintUsage the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrintUsage newPrintUsage, final ICallback<? super PrintUsage> callback) {
        send(HttpMethod.POST, callback, newPrintUsage);
    }

    /**
     * Creates a PrintUsage with a new object
     *
     * @param newPrintUsage the new object to create
     * @return the created PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsage post(final PrintUsage newPrintUsage) throws ClientException {
        return send(HttpMethod.POST, newPrintUsage);
    }

    /**
     * Creates a PrintUsage with a new object
     *
     * @param newPrintUsage the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrintUsage newPrintUsage, final ICallback<? super PrintUsage> callback) {
        send(HttpMethod.PUT, callback, newPrintUsage);
    }

    /**
     * Creates a PrintUsage with a new object
     *
     * @param newPrintUsage the object to create/update
     * @return the created PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsage put(final PrintUsage newPrintUsage) throws ClientException {
        return send(HttpMethod.PUT, newPrintUsage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrintUsageRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrintUsageRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrintUsageRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrintUsageRequest)this;
     }

}

